/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.util.ChangeTrackingSet;
import cz.insophy.inplan.util.DefaultChangeTrackingSet;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.UnmodifiableChangeTrackingSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ActiongramBoundUpdater
extends Processor {
    private static final String ABU_CNT_KEY = "ActiongramBoundUpdater.cnt";
    private final Set<Operation> outputOps = DefaultChangeTrackingSet.create();
    private final Set<Operation> outputOpsView = new UnmodifiableChangeTrackingSet<Operation>((ChangeTrackingSet)this.outputOps);
    private int plannedCnt;
    private int maxBatchCount = 0;
    private PropertyDefinition authPd;
    private PropertyDefinition authConstPd;

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        ShopConfiguration conf = scheduler.getSuperplan().getShopConf();
        this.authPd = conf.getPropertyDefinition(GeneralizedOrderRequest.class, "authorizationDate");
        this.authConstPd = conf.getPropertyDefinition(GeneralizedOrderRequest.class, "authorizationConstraint");
    }

    @Override
    public void onOperationPlanned(Operation op) {
        ++this.plannedCnt;
        for (Operation succOp : op.getSuccessors()) {
            this.updateOpAgBound(succOp);
        }
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (ops instanceof ChangeTrackingSet) {
            ChangeTrackingSet.Changes changes = ((ChangeTrackingSet)ops).getChanges();
            for (Operation op : changes.getAdded()) {
                this.updateOpAgBound(op);
                this.outputOps.add(op);
            }
            for (Operation op : changes.getRemoved()) {
                this.outputOps.remove(op);
            }
            return Tuple.create(this.getDefaultSuccessor(), this.outputOpsView);
        }
        for (Operation op : ops) {
            this.updateOpAgBound(op);
        }
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }

    private void updateOpAgBound(Operation op) {
        Object cnt = op.getProperty(ABU_CNT_KEY);
        if (cnt instanceof Integer && (Integer)cnt >= this.plannedCnt) {
            return;
        }
        long simpleBound = Long.MIN_VALUE;
        HashMap complexBound = Maps.newHashMap();
        Operation boundingPredOp = null;
        for (Operation predOp : op.getPredecessors()) {
            Action predActn = predOp.getAction();
            if (!predOp.isPlanned()) continue;
            if (op.isActiongramStart() || predActn.getTransferBatch() <= 0.0) {
                long startTime = this.getTimeToStartSimple(predOp, op);
                if (startTime <= simpleBound) continue;
                simpleBound = startTime;
                boundingPredOp = predOp;
                continue;
            }
            Map<Workplace, Long> sub = this.getTimeToStartTransferBatch(predOp, op);
            sub.forEach((workplace, t) -> complexBound.merge(workplace, t, Math::max));
        }
        long rd = op.getGar().getReleaseDate();
        if (GeneralizedRequest.isDateValid(rd) && simpleBound <= rd) {
            simpleBound = rd;
            boundingPredOp = null;
        }
        if (op.isActiongramStart()) {
            this.updateAuthorization(op, simpleBound, boundingPredOp);
        }
        op.updateSimpleBound(this, simpleBound);
        for (Map.Entry entry : complexBound.entrySet()) {
            op.updateCompositeBound(this, entry.getKey(), (Long)entry.getValue());
        }
        op.setProperty(ABU_CNT_KEY, this.plannedCnt);
    }

    private void updateAuthorization(@Nonnull Operation op, long agBound, @Nullable Operation boundingPredOp) {
        GeneralizedOrderRequest gor;
        Long auth;
        if (this.authPd != null && ((auth = (Long)(gor = ProductionTreeAlgorithms.getNearestGor(op.getGar())).getProperty(this.authPd)) == null || auth < agBound)) {
            gor.setProperty(this.authPd, agBound);
            if (this.authConstPd != null) {
                String constraint = Localizer.getString("mokos.authorization_rd");
                if (boundingPredOp != null) {
                    constraint = ProductionTreeAlgorithms.getNearestGor(boundingPredOp.getGar()).getId();
                }
                gor.setProperty(this.authConstPd, constraint);
            }
        }
    }

    private long getTimeToStartSimple(Operation predOp, Operation op) {
        Action predActn = predOp.getAction();
        Action actn = op.getAction();
        double tb = predActn.getTransferBatch();
        Preconditions.checkArgument(op.isActiongramStart() || tb <= 0.0);
        long res = Long.MIN_VALUE;
        if (op.isActiongramStart()) {
            res = Util.getFirstPlannedWa(predOp).getStart() + actn.getMinTimeToPrepare();
        } else if (tb < 0.0) {
            res = Util.getLastPlannedAa(predOp).getEnd() + actn.getMinTimeToPrepare();
        } else if (tb == 0.0) {
            res = Util.getFirstPlannedAa(predOp).getStart() + actn.getMinTimeToPrepare();
        }
        return res;
    }

    private Map<Workplace, Long> getTimeToStartTransferBatch(Operation predOp, Operation op) {
        Preconditions.checkArgument(predOp.isPlanned());
        Preconditions.checkArgument(!op.isActiongramStart());
        Action predActn = predOp.getAction();
        Action actn = op.getAction();
        Preconditions.checkArgument(predActn.getTransferBatch() > 0.0);
        double tb = this.maxBatchCount > 0 ? Math.max(predOp.getGar().getRequestedQty() / (double)this.maxBatchCount, predActn.getTransferBatch()) : predActn.getTransferBatch();
        double unplannedBatchTime = (double)actn.getProductionTime() * tb * actn.getQtyCoef() / predActn.getQtyCoef();
        double unplannedLastBatchSize = predOp.getGar().getRequestedQty() % tb;
        if (unplannedLastBatchSize <= 1.0E-7) {
            unplannedLastBatchSize = tb;
        }
        double unplannedLastBatchLength = (double)actn.getProductionTime() * unplannedLastBatchSize;
        double predOop = predOp.getGar().getOutOfPlanQty();
        int predCompletedBatches = (int)Math.floor(predOop / tb);
        double oop = op.getGar().getOutOfPlanQty();
        int completedBatches = (int)Math.ceil(oop / tb);
        int effectiveFirstBatch = Math.max(completedBatches - predCompletedBatches, 0);
        double time = actn.timeToMake(op.getGar().getAmount());
        List<Long> plannedBatchTimes = ActiongramBoundUpdater.getBatchTimes(predOp.getPlannings().get(0).getActivityChanges(), tb, predOop);
        long maxStart = Long.MIN_VALUE;
        if (time < unplannedLastBatchLength) {
            List<ActivityChange> acs = predOp.getPlannings().get(0).getActivityChanges();
            for (ActivityChange ac : Lists.reverse(acs)) {
                if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !(ac.getActivity() instanceof ActionActivity)) continue;
                maxStart = ac.getActivity().getEnd();
                break;
            }
            return this.getFirstAvailableTime(maxStart, actn.getCapabilityReq());
        }
        for (ActivityChange ac : predOp.getPlannings().get(0).getActivityChanges()) {
            if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !(ac.getActivity() instanceof ActionActivity)) continue;
            maxStart = ac.getActivity().getStart();
            break;
        }
        if (effectiveFirstBatch > 0) {
            long batchTime = plannedBatchTimes.get(effectiveFirstBatch - 1);
            long t = batchTime + actn.getMinTimeToPrepare();
            maxStart = Math.max(maxStart, t);
        }
        Map<Workplace, Long> maxStarts = this.getMaxStart(actn.getCapabilityReq(), plannedBatchTimes, actn, effectiveFirstBatch, time, unplannedLastBatchLength, unplannedBatchTime);
        HashMap<Workplace, Long> res = Maps.newHashMap();
        for (Map.Entry<Workplace, Long> entry : maxStarts.entrySet()) {
            res.put(entry.getKey(), Math.max(maxStart, entry.getValue()));
        }
        return res;
    }

    private Map<Workplace, Long> getMaxStart(String capability, List<Long> plannedBatchTimes, Action actn, int firstBatchIdx, double totalTime, double lastBatchLength, double batchLength) {
        List<Workplace> workplaces = this.getScheduler().getSuperplan().getShopConf().getWorkplaces(capability);
        HashMap<Workplace, Long> res = Maps.newHashMapWithExpectedSize(workplaces.size());
        for (Workplace workplace : workplaces) {
            res.put(workplace, this.getMaxStart(workplace, plannedBatchTimes, actn, firstBatchIdx, totalTime, lastBatchLength, batchLength));
        }
        return res;
    }

    private long getMaxStart(Workplace workplace, List<Long> plannedBatchTimes, Action actn, int firstBatchIdx, double totalTime, double lastBatchLength, double batchLength) {
        double readyTime;
        double currentBatch;
        double maxStart;
        int batchIdx = plannedBatchTimes.size() - 1;
        double newMaxStart = maxStart = (double)(plannedBatchTimes.get(batchIdx) + actn.getMinTimeToPrepare());
        double continueTime = maxStart;
        WorkplaceActivity obstacle = null;
        Iterator<WorkplaceActivity> wpIt = this.getScheduler().getSuperplan().getPlan().getWorkplaceSchedule(workplace).backwardIterator(Math.round(maxStart), true);
        while (wpIt.hasNext()) {
            WorkplaceActivity next = wpIt.next();
            if ((double)next.getEnd() <= maxStart) {
                obstacle = next;
                break;
            }
            if (!((double)next.getStart() <= maxStart) || !(maxStart < (double)next.getEnd())) continue;
            obstacle = next;
            break;
        }
        if (batchIdx < firstBatchIdx) {
            currentBatch = totalTime;
            readyTime = Double.NEGATIVE_INFINITY;
        } else {
            currentBatch = lastBatchLength;
            readyTime = maxStart;
        }
        while (totalTime > 0.0) {
            if (newMaxStart >= readyTime && (obstacle == null || newMaxStart >= (double)obstacle.getEnd())) {
                maxStart = newMaxStart;
                continueTime = newMaxStart;
            } else if (readyTime >= newMaxStart && (obstacle == null || readyTime >= (double)obstacle.getEnd())) {
                maxStart = readyTime;
                continueTime = readyTime;
            } else if (obstacle != null && (double)obstacle.getEnd() >= newMaxStart && (double)obstacle.getEnd() >= readyTime) {
                if (readyTime >= (double)obstacle.getStart()) {
                    maxStart = obstacle.getEnd();
                    continueTime = obstacle.getStart();
                    totalTime -= currentBatch;
                    if (--batchIdx < firstBatchIdx) {
                        currentBatch = totalTime;
                        readyTime = Double.NEGATIVE_INFINITY;
                    } else {
                        currentBatch = Math.min(batchLength, totalTime);
                        readyTime = plannedBatchTimes.get(batchIdx) + actn.getMinTimeToPrepare();
                    }
                    if (!((newMaxStart = continueTime - currentBatch) < (double)obstacle.getStart()) || !(readyTime < (double)obstacle.getStart())) continue;
                    obstacle = wpIt.hasNext() ? wpIt.next() : null;
                    continue;
                }
                maxStart = obstacle.getEnd();
                totalTime -= continueTime - maxStart;
                continueTime = obstacle.getStart();
                newMaxStart = continueTime - (currentBatch -= continueTime - (double)obstacle.getEnd());
                obstacle = wpIt.hasNext() ? wpIt.next() : null;
                continue;
            }
            totalTime -= currentBatch;
            if (--batchIdx < firstBatchIdx) {
                currentBatch = totalTime;
                readyTime = Double.NEGATIVE_INFINITY;
            } else {
                currentBatch = Math.min(batchLength, totalTime);
                readyTime = plannedBatchTimes.get(batchIdx) + actn.getMinTimeToPrepare();
            }
            newMaxStart = continueTime - currentBatch;
        }
        return Math.round(maxStart);
    }

    private static List<Long> getBatchTimes(List<ActivityChange> acs, double batch, double oopQty) {
        ArrayList<Long> res = Lists.newArrayList();
        Iterator<ActivityChange> acIt = acs.iterator();
        Activity aa = null;
        while (acIt.hasNext()) {
            ActivityChange ac = acIt.next();
            if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !(ac.getActivity() instanceof ActionActivity)) continue;
            aa = (ActionActivity)ac.getActivity();
            break;
        }
        if (aa == null) {
            return res;
        }
        long aaTime = aa.getDuration();
        double aaQty = ((ActionActivity)aa).getQty();
        double totalRemainingQty = 0.0;
        for (ActivityChange ac : acs) {
            if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !(ac.getActivity() instanceof ActionActivity)) continue;
            totalRemainingQty += ((ActionActivity)ac.getActivity()).getQty();
        }
        double aaRemainingQty = aaQty;
        double fracTime = aa.getStart();
        double effectiveBatch = batch - oopQty % batch;
        double d = (double)aaTime / (aaQty / effectiveBatch);
        while (totalRemainingQty > 1.0E-7) {
            long time;
            if (effectiveBatch < aaRemainingQty + 1.0E-7) {
                time = Math.round(fracTime += d);
                res.add(time);
                aaRemainingQty -= effectiveBatch;
                totalRemainingQty -= effectiveBatch;
                effectiveBatch = batch;
                d = (double)aaTime / (aaQty / effectiveBatch);
                continue;
            }
            if (batch < totalRemainingQty + 1.0E-7) {
                totalRemainingQty -= aaRemainingQty;
                double overshootQty = effectiveBatch - aaRemainingQty;
                long lastAaEnd = aa.getEnd();
                while (acIt.hasNext()) {
                    ActivityChange ac = acIt.next();
                    if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !(ac.getActivity() instanceof ActionActivity)) continue;
                    aa = (ActionActivity)ac.getActivity();
                    break;
                }
                aaQty = ((ActionActivity)aa).getQty();
                aaTime = aa.getDuration();
                aaRemainingQty = aaQty;
                effectiveBatch = overshootQty;
                d = (double)lastAaEnd - fracTime;
                d += (double)(aa.getStart() - lastAaEnd);
                d += (double)aaTime / (aaQty / effectiveBatch);
                continue;
            }
            if (acIt.hasNext()) {
                ActivityChange ac = acIt.next();
                if (ac.getChangeType() != ActivityChange.ChangeType.ADDED || !(ac.getActivity() instanceof ActionActivity)) continue;
                aa = (ActionActivity)ac.getActivity();
                continue;
            }
            time = aa.getEnd();
            res.add(time);
            break;
        }
        return res;
    }

    private Map<Workplace, Long> getFirstAvailableTime(long t, String capability) {
        List<Workplace> workplaces = this.getScheduler().getSuperplan().getShopConf().getWorkplaces(capability);
        HashMap<Workplace, Long> res = Maps.newHashMapWithExpectedSize(workplaces.size());
        for (Workplace workplace : workplaces) {
            res.put(workplace, this.getFirstAvailableTime(t, workplace));
        }
        return res;
    }

    private long getFirstAvailableTime(long t, Workplace workplace) {
        WorkplaceActivity activity;
        Iterator<WorkplaceActivity> waIt = this.getScheduler().getSuperplan().getPlan().getWorkplaceSchedule(workplace).forwardIteratorWithBubbles(t, true);
        if (waIt.hasNext() && (activity = waIt.next()) instanceof Bubble) {
            return t;
        }
        while (waIt.hasNext()) {
            activity = waIt.next();
            if (!(activity instanceof Bubble)) continue;
            return activity.getStart();
        }
        return t;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public void setMaxBatchCount(int maxBatchCount) {
        this.maxBatchCount = maxBatchCount;
    }
}

